package gov.va.med.mhv.bluebutton.web.bean;

import gov.va.med.mhv.bluebutton.transfer.StudyDTO;
import gov.va.med.mhv.bluebutton.transfer.StudyJobDTO;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.bean.ManagedBean;

import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean
@Component
@Scope("session")
public class StudyListBean implements Serializable {
	private static final long serialVersionUID = -1694898992157594161L;
	
	//private static final String URIBASE="/mhvapi/v1/bluebutton/external/studyjob/bbreport/studyidUrn/{studyIdUrn}";
	private static final String URIBASE="/mhvapi/v1/bluebutton/external/studyjob/bbreport/studyidUrn/{studyIdUrn}/downloadReportId/{downloadReportId}/type/{type}";
	private List<StudyDTO> studies = new ArrayList<StudyDTO>();
	private Map<String,StudyDTO> studyIdUrnIndex = new HashMap<String,StudyDTO>();
	
	private StudyDTO selectedStudy;
	private List<String> selectedStudyFileList;
	
	private boolean isStatusLoaded = false;
	private Long bbDownloadReportId;
	
	private boolean stop = true;
	
	public StudyDTO getSelectedStudy() {
		return selectedStudy;
	}

	public String getSelectedStudyImage(int id) {
		return selectedStudyFileList.get(id-1);
	}
	
	/**
	 * Only add files if they are a type of extension that is visible in a typical browser.
	 * (jpg, png, gif)
	 * @return
	 */
	public List<StudyImageInfo> getSelectedStudyImageList() {
		List<StudyImageInfo> result = new ArrayList<StudyImageInfo>();
		
		int i = 1;
		int total = selectedStudyFileList.size();
		for(String file: selectedStudyFileList) {
			StudyImageInfo image = null;
			if( file.endsWith("jpg") || file.endsWith("png") || file.endsWith("gif") || file.endsWith("jpeg") ) {
				image = new StudyImageInfo(i,total,file,selectedStudy.getStudyIdUrn(), true);
			} else {
				image = new StudyImageInfo(i,total,file,selectedStudy.getStudyIdUrn(),false);
			}
			result.add(image);
			i++;
		}
		return result;
	}
	
	public void setSelectedStudy(StudyDTO selectedStudy) {
		this.selectedStudy = selectedStudy;
	}

	public Boolean getDataLoaded() {
		return isStatusLoaded;
	}

	public List<StudyDTO> getStudies() {
		return studies;
	}

	public void setStudies(List<StudyDTO> studies) {
		this.studies = studies;
		isStatusLoaded = true;
		studyIdUrnIndex = new HashMap<String,StudyDTO>();
		for( StudyDTO s: studies) {
			if( !studyIdUrnIndex.containsKey(s.getStudyIdUrn()) ) {
				studyIdUrnIndex.put(s.getStudyIdUrn(), s);
			} else {
				throw new RuntimeException("Found duplicate studyIdUrn");
			}
		}
	}
	
	public boolean getAnyInProgress() {
		boolean result = false;
		for( StudyDTO s: studies ) {
			if(s.getStudyJob()!=null) {
				result = !s.getStudyJob().getStatus().equals("COMPLETE");
				if(result) break;
			}
		}
		return result;
	}
	
	public boolean getAnyProcessing() {
		boolean result = false;
		for( StudyDTO s: studies ) {
			if(s.getStudyJob()!=null) {
				result = s.getStudyJob().getStatus().equals("PROCESSING");
				if(result) break;
			}
		}
		return result;
	}
	
	public boolean getAnyInError() {
		boolean result = false;
		for( StudyDTO s: studies ) {
			if(s.getStudyJob()!=null) {
				result = result || s.getStudyJob().getStatus().equals("ERROR");
				if(result) break;
			}
		}
		return result;
	}
	
	public void clearStudyJobList() {
		//Reset the job statuses
		for(StudyDTO s: studies ) {
			s.setStudyJob(null);
		}
	}
	
	public void setStudyJobList(List<StudyJobDTO> studyJobs) {
		clearStudyJobList();
		
		//Update the Studies with their StudyJob status
		for( StudyJobDTO sj: studyJobs ) {
			StudyDTO study = studyIdUrnIndex.get(sj.getStudyIdUrn());
			if( study != null ) {
				study.setStudyJob(sj);
			}
		}
	}

	public void setStudyJob(StudyJobDTO job) {
		StudyDTO study = studyIdUrnIndex.get(job.getStudyIdUrn());
		if( study != null ) {
			study.setStudyJob(job);
		}
	}

	public List<String> getSelectedStudyFileList() {
		return selectedStudyFileList;
	}

	public void setSelectedStudyFileList(List<String> files) {
		this.selectedStudyFileList = files;
	}

	public String getSelectedStudyReportURIforTXT() {
		String url = StringUtils.replace(URIBASE, "{downloadReportId}", String.valueOf(bbDownloadReportId));
		url = StringUtils.replace(url, "{studyIdUrn}", selectedStudy.getStudyIdUrn());
		return StringUtils.replace(url, "{type}", "TXT");
	}

	public String getSelectedStudyReportURIforTXTDL() {
		String url = StringUtils.replace(URIBASE, "{downloadReportId}", String.valueOf(bbDownloadReportId));
		url = StringUtils.replace(url, "{studyIdUrn}", selectedStudy.getStudyIdUrn());
		return StringUtils.replace(url, "{type}", "TXTDL");
	}
	
	public String getSelectedStudyReportURIforPDF() {
		String url = StringUtils.replace(URIBASE, "{downloadReportId}", String.valueOf(bbDownloadReportId));
		url = StringUtils.replace(url, "{studyIdUrn}", selectedStudy.getStudyIdUrn());
		return StringUtils.replace(url, "{type}", "PDF");
	}
	
	public String getSelectedStudyReportURIforPDFDL() {
		String url = StringUtils.replace(URIBASE, "{downloadReportId}", String.valueOf(bbDownloadReportId));
		url = StringUtils.replace(url, "{studyIdUrn}", selectedStudy.getStudyIdUrn());
		return StringUtils.replace(url, "{type}", "PDFDL");
	}

	public String getSelectedStudyReportURIforViewTXT() {
		String url = StringUtils.replace(URIBASE, "{downloadReportId}", String.valueOf(bbDownloadReportId));
		url = StringUtils.replace(url, "{studyIdUrn}", selectedStudy.getStudyIdUrn());
		return StringUtils.replace(url, "{type}", "VIEWTXT");
	}
	
	public Long getBbDownloadReportId() {
		return bbDownloadReportId;
	}

	public void setBbDownloadReportId(Long bbDownloadReportId) {
		this.bbDownloadReportId = bbDownloadReportId;
	}

	public boolean isStop() {
		return stop;
	}

	public void setStop(boolean stop) {
		this.stop = stop;
	}
	
}
